<?php

namespace App\Exports;

use App\Models\UnsubscribeClient;
use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class GlobalUnsubscribesExport implements FromCollection, WithHeadings
{
    private $search;

    public function __construct($request)
    {
        $this->search = $request;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        $search = $this->search;
        return UnsubscribeClient::own()->orderBy('id', 'desc')
            ->when(isset($search['daterange']), function ($query) use ($search) {
                list($startDate, $endDate) = explode(' - ', $search['daterange']);
                $startDate = Carbon::parse($startDate)->startOfDay();
                $endDate = Carbon::parse($endDate)->endOfDay();
                $query->whereBetween('created_at', [$startDate, $endDate]);
            })
            ->when(isset($search['email_address']), function ($query) use ($search) {
                $query->where('email_address', 'LIKE', '%' . $search['email_address'] . '%');
            })->get()->map(function ($query) {
                $data['Email Address'] = $query->email_address;
                return $data;
            });
    }

    public function headings(): array
    {
        return [
            'Email Address',
        ];
    }
}
