<?php

namespace App\Exports;

use App\Models\EmailAutomationMap;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ExportScheduleEmail implements FromCollection, WithHeadings
{
    private $scheduleId;

    public function __construct($scheduleId)
    {
        $this->scheduleId = $scheduleId;
    }

    public function collection()
    {
        return EmailAutomationMap::own()->where('automation_schedule_id', $this->scheduleId)
            ->get()->map(function ($query) {
                $data['Email'] = $query->email_address;
                return $data;
            });
    }

    public function headings(): array
    {
        return [
            'Email',
        ];
    }
}
