<?php

namespace App\Exports;

use App\Models\EmailAutomationMap;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ExportAutomationActivityEmail implements FromCollection, WithHeadings
{
    private $automationId;
    private $type;

    /**
     * @return \Illuminate\Support\Collection
     */
    public function __construct($automationId, $type)
    {
        $this->automationId = $automationId;
        $this->type = $type;
    }

    public function collection()
    {
        $type = $this->type;
        return EmailAutomationMap::own()->where('automation_id', $this->automationId)
            ->when(isset($type), function ($query) use ($type) {
                if ($type == 'delivered') {
                    $query->where('delivered', 1);
                } elseif ($type == 'bounces') {
                    $query->where('bounces', 1);
                } elseif ($type == 'unique_opens') {
                    $query->where('unique_opens', 1);
                } elseif ($type == 'unsubscribe') {
                    $query->where('unsubscribes', 1);
                }
            })
            ->orderBy('id', 'desc')
            ->get()->map(function ($query) {
                $data['Email'] = $query->email_address;
                return $data;
            });
    }

    public function headings(): array
    {
        return [
            'Email',
        ];
    }
}
