<?php

namespace App\Console\Commands;

use App\Jobs\SingleSendEmails;
use App\Models\SingleSend;
use Carbon\Carbon;
use Illuminate\Console\Command;

class SingleSendCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:single-send-cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Single Send Schedule Mail Send From Here';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $basicControl = basicControl();
        $params = ['emailThrottleTime' => $basicControl->emailThrottleTime, 'emailThrottleStatus' => $basicControl->emailThrottleStatus];
        $singleSends = SingleSend::own()->where('status', 1)
            ->whereDate('schedule_date', '<=', Carbon::now())->whereTime('schedule_time', '<=', Carbon::now())
            ->where('schedule_type', 1)->get();
        if (count($singleSends) > 0) {
            foreach ($singleSends as $singleSend) {
                $singleSend->status = 2;
                $singleSend->sent_at = Carbon::now();
                $singleSend->save();
                dispatch(new SingleSendEmails($singleSend, url('/'), $params));
            }
        }
    }
}
