<?php

namespace App\Console\Commands;

use App\Models\BulkEmailCheck;
use Carbon\Carbon;
use Illuminate\Console\Command;

class BulkEmailCheckDelete extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:bulk-email-check-delete';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generated result delete';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        BulkEmailCheck::whereDate('created_at', '<', Carbon::now()->subDay())->get()->map(function ($query) {
            $query->delete();
        });
    }
}
