<?php

namespace App\Console\Commands;

use App\Models\Automation;
use App\Models\EmailAutomationMap;
use Carbon\Carbon;
use Illuminate\Console\Command;

class AutomationStaticsCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:automation-statics-cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update Automation Statics and which email are fail';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $currenDate = Carbon::now()->toDateString();
        EmailAutomationMap::where('status', 0)
            ->whereDate('triggered_date', '<', $currenDate)->get()->map(function ($query) {
                $query->status = 2;
                $query->save();
            });

        Automation::select(['id', 'live_at', 'total_triggered', 'total_delivered', 'total_unique_opens',
            'total_opens', 'total_bounces', 'total_unsubscribe'])
            ->with('emailAutomationMaps:id,automation_id,status,delivered,unique_opens,total_opens,bounces,unsubscribes')
            ->whereNotNull('live_at')
            ->get()->map(function ($query) {
                $recipients = $query->emailAutomationMaps->where('status', 1);
                $query->total_triggered = count($recipients);
                $query->total_delivered = count($recipients->where('delivered', 1));
                $query->total_unique_opens = count($recipients->where('unique_opens', 1));
                $query->total_opens = $recipients->sum('total_opens');
                $query->total_bounces = count($recipients->where('bounces', 1));
                $query->total_unsubscribe = count($recipients->where('unsubscribes', 1));
                $query->save();
            });
    }
}
